//Income Elasticity Of Demand
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//Concept Information
//Formula= % Change in Income/% Change in Q.D.
//Ei =  (ΔQ/ΔY) * (Yo/Qo)
//ΔQ is the Change in Quantity [Q0-Q1] (or) Initial Quantity - Final Quantity

//Given
I0=4000       //in rupees
I1=5000      //in rupees
Q0=20     //in units
Q1=25     //in units

//Solution
Ei=((Q0-Q1)/(I0-I1)*(I0/Q0))

//Values
mprintf("   Income(in rupees)     Commodity Demand(in units)")
mprintf("\n     %d\t\t\t%d",I0,Q0)
mprintf("\n     %d\t\t\t%d",I1,Q1)

//Result
//Note: -ve sign is ignored
mprintf("\n     Ei:%d",Ei)
if Ei == 1 then
    mprintf("\nUnity Elasticity Of Demand")
elseif Ei > 1 then
    mprintf("\nGreater than Elasticity Of Demand")
else
    mprintf("\nLess than Elasticity Of Demand")
end

//Output
//    Income(in rupees)     Commodity Demand(in units)
//     4000			20
//     5000			25
//     Ei:1
// Unity Elasticity Of Demand
